/* =========================================================
	Dirk Poutain's HEAP in mForth
	modified by R. Saric 
   ========================================================= */

macro on

#ifndef gemdos
	bload bin\gemdos.bin >voc gemdos
#endif

mforth system also definitions

integer heapsize 	8000 to heapsize
integer heap	
integer endheap

variable *heap
variable *handle
variable *free

: heap>		( -- addr )		*heap   @ ;
: +heap>		( n -- )			*heap   +! ;
: handle>	( -- handle )	*handle @ ;
: +handle>	( n -- )			*handle +! ;

: heapinit	( -- flag )
	heapsize gemdos m_alloc dup 0>
	if		to heap
			heap heapsize + to endheap
			heap heapsize erase	/* to zero	*/
			heap *heap !			/* reset all pointers	*/
			endheap 4- *handle !
			*free off  true
	else	drop false
	endif ;

: heapkill	( -- )	heap gemdos m_free drop ;

: adjust_handles	( n addr -- )
	swap negate endheap handle> 4+
	do		i @ 2pick > handle> i @ - 0> and
			if	i over swap +!	endif
	4 +loop 2drop ;

: get_handle		( -- hdl )
	*free @ ?dup 0=
	if		handle> -4 +handle>
	else	dup @ *free !
	endif ;

: alloc				( size -- hdl | 0 )
	dup handle> heap> rot + 4+ - 0< not
	if		get_handle
			heap> 4+ over !
			over heap> !
			swap 4+ +heap>
	else	drop false
	endif ;

: size?				( hdl -- size )	@ 4- @ ;
: free				( hdl -- )
	dup size? 4+
	over @ 4- 2dup + dup >r
	swap heap> r@ - cmove
	dup negate +heap>
	swap *free @ over ! *free ! 
	r> adjust_handles ;

hide heap heapinit
hide adjust_handles alloc

mforth


